/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.graphics.shader;

import icyllis.modernui.ModernUI;
import icyllis.modernui.annotation.RenderThread;
import icyllis.modernui.graphics.shader.Shader;
import icyllis.modernui.platform.RenderCore;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL43C;

public class ShaderProgram {
    private static final List<ShaderProgram> PROGRAMS = new ArrayList<ShaderProgram>();
    private Shader mVertex;
    private Shader mFragment;
    @Nonnull
    private final ResourceLocation mVert;
    @Nonnull
    private final ResourceLocation mFrag;
    protected final int mId;

    @RenderThread
    public ShaderProgram(@Nonnull ResourceLocation vert, @Nonnull ResourceLocation frag) {
        this.mVert = vert;
        this.mFrag = frag;
        this.mId = GL43C.glCreateProgram();
        PROGRAMS.add(this);
    }

    public void link(IResourceManager manager) throws IOException {
        this.detach();
        this.mVertex = Shader.getOrCreate(manager, this.mVert, Shader.Type.VERTEX);
        this.mFragment = Shader.getOrCreate(manager, this.mFrag, Shader.Type.FRAGMENT);
        this.mVertex.attach(this);
        this.mFragment.attach(this);
        GL43C.glLinkProgram((int)this.mId);
        if (GL43C.glGetProgrami((int)this.mId, (int)35714) == 0) {
            ModernUI.LOGGER.error(RenderCore.MARKER, "Failed to link shader program {}, detailed info:\n{}", (Object)this, (Object)GL43C.glGetProgramInfoLog((int)this.mId, (int)8192));
        }
    }

    public void detach() {
        if (this.mVertex != null) {
            this.mVertex.detach(this);
            this.mVertex = null;
        }
        if (this.mFragment != null) {
            this.mFragment.detach(this);
            this.mFragment = null;
        }
    }

    public void use() {
        GL43C.glUseProgram((int)this.mId);
    }

    public static void stop() {
        GL43C.glUseProgram((int)0);
    }

    public static void linkAll(IResourceManager manager) {
        PROGRAMS.forEach(program -> {
            try {
                program.link(manager);
            }
            catch (IOException e) {
                ModernUI.LOGGER.error(RenderCore.MARKER, "An error occurred while linking program: {}", program, (Object)e);
            }
        });
        ModernUI.LOGGER.debug(RenderCore.MARKER, "Shader programs linked");
    }

    public static void detachAll() {
        PROGRAMS.forEach(ShaderProgram::detach);
    }

    public static void recompile(IResourceManager manager) {
        ShaderProgram.detachAll();
        Shader.deleteAll();
        ShaderProgram.linkAll(manager);
    }
}

